/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class UtilInventory {
    public static void nukeAndDrop(DimPos lookPos) {
        lookPos.getWorld().m_46961_(lookPos.getBlockPos(), true);
        lookPos.getWorld().m_46747_(lookPos.getBlockPos());
    }

    public static String getStackKey(ItemStack stackInCopy) {
        return stackInCopy.m_41720_().getRegistryName().toString();
    }

    public static Triple<String, Integer, ItemStack> getCurioRemote(Player player, Item remote) {
        ItemStack temp;
        int i;
        SlotResult first;
        Triple stackFound = Triple.of((Object)"", (Object)-1, (Object)ItemStack.f_41583_);
        if (UtilInventory.isRemoteWithData(player.m_21205_(), remote)) {
            return Triple.of((Object)"hand", (Object)-1, (Object)player.m_21205_());
        }
        if (ModList.get().isLoaded("curios") && (first = (SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, remote).orElse(null)) != null && UtilInventory.isRemoteWithData(first.stack(), remote)) {
            return Triple.of((Object)"curios", (Object)first.slotContext().index(), (Object)first.stack());
        }
        for (i = 0; i < player.m_36327_().m_6643_(); ++i) {
            temp = player.m_36327_().m_8020_(i);
            if (!UtilInventory.isRemoteWithData(temp, remote)) continue;
            return Triple.of((Object)"ender", (Object)i, (Object)temp);
        }
        for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
            temp = player.m_150109_().m_8020_(i);
            if (!UtilInventory.isRemoteWithData(temp, remote)) continue;
            return Triple.of((Object)"player", (Object)i, (Object)temp);
        }
        if (UtilInventory.isRemoteWithData(player.m_21206_(), remote)) {
            return Triple.of((Object)"offhand", (Object)-1, (Object)player.m_21206_());
        }
        return stackFound;
    }

    private static boolean isRemoteWithData(ItemStack stack, Item remote) {
        return stack.m_41720_() == remote && stack.m_41782_();
    }

    public static String formatLargeNumber(int size) {
        if ((double)size < Math.pow(10.0, 3.0)) {
            return "" + size;
        }
        if ((double)size < Math.pow(10.0, 6.0)) {
            int rounded = Math.round((float)size / 1000.0f);
            return rounded + "K";
        }
        if ((double)size < Math.pow(10.0, 9.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 6.0));
            return rounded + "M";
        }
        if ((double)size < Math.pow(10.0, 12.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 9.0));
            return rounded + "B";
        }
        return "" + size;
    }

    public static int countHowMany(IItemHandler inv, ItemStack stackIn) {
        int found = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stackIn)) continue;
            found += inv.getStackInSlot(i).m_41613_();
        }
        return found;
    }

    public static int containsAtLeastHowManyNeeded(IItemHandler inv, ItemStack stackIn, int minimumCount) {
        int found = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stackIn)) continue;
            found += inv.getStackInSlot(i).m_41613_();
        }
        if (found >= minimumCount) {
            return 0;
        }
        return minimumCount - found;
    }

    public static ItemStack extractItem(IItemHandler inv, ItemStackMatcher fil, int num, boolean simulate) {
        if (inv == null || fil == null) {
            return ItemStack.f_41583_;
        }
        int extracted = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack ex;
            ItemStack slot = inv.getStackInSlot(i);
            if (!fil.match(slot) || (ex = inv.extractItem(i, 1, simulate)).m_41619_()) continue;
            if (++extracted == num) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)slot, (int)num);
            }
            --i;
        }
        return ItemStack.f_41583_;
    }

    public static void dropItem(Level world, BlockPos pos, ItemStack stack) {
        if (pos == null || world.f_46443_ || stack.m_41619_()) {
            return;
        }
        world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
    }
}

